/* header.c */
/* This is part of the source for the Core Join Calculus Compiler cjcc */
/* Copyright (C) 1996 Peter Selinger */
/* This is free software under the terms of the GNU General Public License. */

"#include <stdio.h>\n"
"\n"
"struct incarnation;\n"
"struct queue;\n"
"struct queuelink;\n"
"\n"
"typedef struct channel{\n"
"  struct incarnation *inc;\n"
"  int entry;\n"
"} channel;\n"
"\n"
"#define CHANNEL 1\n"
"#define INT 2\n"
"#define STR 3\n"
"#define BOOLE 4\n"
"#define WILDCARD 5\n"
"typedef struct value {\n"
"  int type;       /* one of CHANNEL, INT, STR, BOOLE, WILDCARD */\n"
"  union {\n"
"    channel chan; /* type=CHANNEL */\n"
"    int i;        /* type=INT */\n"
"    char *s;      /* type=STR */\n"
"    int b;        /* type=BOOLE */\n"
"  } c;\n"
"} value;\n"
"\n"
"value dummy;\n"
"value tmp_val;\n"
"\n"
"value inint(int i) {\n"
"  value out;\n"
"\n"
"  out.type=INT;\n"
"  out.c.i=i;\n"
"  return out;\n"
"}\n"
"\n"
"value instr(char *s) {\n"
"  value out;\n"
"\n"
"  out.type=STR;\n"
"  out.c.s=s;\n"
"  return out;\n"
"}\n"
"\n"
"value inboole(int b) {\n"
"  value out;\n"
"\n"
"  out.type=BOOLE;\n"
"  out.c.b=b;\n"
"  return out;\n"
"}\n"
"\n"
"typedef struct incarnation {\n"
"  void (*code)(struct incarnation *, int);\n"
"  struct queue *q;\n"
"  int *arity;\n"
"  value *v;\n"
"} incarnation;\n"
"\n"
"int run_time_err(char *s) {\n"
"  printf(\"\\nRuntime Error:\\n\%s.\\n\",s);\n"
"  exit(1);\n"
"}\n"
"\n"
"int run_time_err2(char *s,int i) {\n"
"  printf(\"\\nRuntime Error:\\n\");\n"
"  printf(s, i);\n"
"  printf(\".\\n\");\n"
"  exit(1);\n"
"}\n"
"\n"
"typedef struct queuelink {\n"
"  value v;\n"
"  struct queuelink *next;\n"
"} queuelink;\n"
"\n"
"typedef struct queue {\n"
"  queuelink *first;\n"
"  queuelink **last;\n"
"  int len;\n"
"} queue;\n"
"\n"
"void init_queue(queue *q) {\n"
"  q->len=0;\n"
"  q->last=&q->first;\n"
"}\n"
"\n"
"int push(value v, queue *q) {\n"
"  queuelink *ptr;\n"
"  ptr=(queuelink *)calloc(1,sizeof(queuelink));\n"
"  if (ptr==NULL)\n"
"    return 0;\n"
"  ptr->v=v;\n"
"  *(q->last)=ptr;\n"
"  q->last=&ptr->next;\n"
"  q->len++;\n"
"  return 1;\n"
"}\n"
"\n"
"int pop(value *v, queue *q) {\n"
"  queuelink *ptr;\n"
"\n"
"  if (q->len==0)\n"
"    return 0;\n"
"  ptr=q->first;\n"
"  *v=ptr->v;\n"
"  q->first=ptr->next;\n"
"  cfree(ptr);\n"
"  q->len--;\n"
"  if (q->len==0)\n"
"    q->last=&q->first;\n"
"  return 1;\n"
"}\n"
"\n"
"int queue_length(queue *q) {\n"
"  return q->len;\n"
"}\n"
"\n"
