// gcd.j prompts for two numbers and returns the greatest common divisor.
// It is written in the core join calculus and compiles under v0.4 of cjcc.
// To compile and run:	cjcc -o gcd.c gcd.j
//			gcc -o gcd gcd.c	 
//			gcd
// Author: Peter Selinger, University of Pennsylvania			 
// Copyright (C) 1996 Peter Selinger
// This is free software under the terms of the GNU General Public License. 

def /* main */
	main<> --> { 

def /* exception_handling */
	e<str>		--> write<"An exception was raised: ", l1, e2> 
			     | store<str>
  and	l1<> 
	 | store<str>	--> write<str, l2, e2>
  and	l2<>		--> write<"\n", main, e2>
  and	e2<str>		--> {}  
in

def /* input_two_numbers */
	input2<respond>		--> write<"Please input two numbers: ",l1,e>
				     | store0<respond>
  and	l1<>			--> readint<a,e>
  and	a<first>		--> store1<first> 
				     | readint<b,e>
  and	b<second>  
	 | store1<first>
	 | store0<respond>	--> respond<first,second>
in

def /* are_the_numbers_positive */
	positive<a,b,yes,no>	--> less<0,a,pos_a,e> 
				     | less<0,b,pos_b,e>
				     | store<yes,no>
  and	pos_a<ispos>		--> if<ispos,good,bad,e>
  and	pos_b<ispos>		--> if<ispos,good,bad,e>
  and	good<> | good<> | store<yes,no>		--> yes<>
  and   bad<>  | bad<>	| store<yes,no>		--> no<>
  and   good<> | bad<>	| store<yes,no>		--> no<>
in

def /* compute_gcd */
	gcd<a,b,result>	--> store<a,b>
				     | store0<result>
                                     | equal<a,b,eq,e>
  and	eq<isequal>		--> if<isequal,case0,case1,e>
  and	case0<> 
	 | store<a,b>	
	 | store0<result>	--> result<a>  // if a=b, done 
  and	case1<>
	 | store<a,b>		--> store<a,b>
				     | less<a,b,ls,e>
  and	ls<isless>		--> if<isless,case2,case3,e>
  and	case2<>	
	 | store<a,b>
	 | store0<result>	--> gcd<b,a,result> // if a<b, do gcd(b,a)
  and	case3<>
	 | store<a,b>		--> minus<a,b,diff,e>
				     | store1<b>
  and	diff<d> 
	 | store1<b>
	 | store0<result>	--> gcd<d,b,result> // do gcd(a-b,b) 
in

def /* start */
	start<>			--> input2<two_numbers> 
  and	two_numbers<a,b>	--> store<a,b>	
				     | positive<a,b,yes,no>
  and	yes<> 
  	 | store<a,b>		--> gcd<a,b,result>
  and	result<n>		--> write<"The gcd is: ", l1, e>
				     | store1<n>
  and	l1<> 
	 | store1<n>		--> write<n, l2, e>
  and	l2<>			--> write<"\n", stop, e>
  and   stop<>			--> {}
  and   no<>
	 | store<a,b>		--> write<"Positive numbers, please.\n", l3, e>
  and	l3<>			--> start<>
in

start<>

} in main<>
