// numbers.j prompts for two numbers and does a few calculations. If
// division by 0 or end of file is encountered, an exception is raised.
// It is written in the core join calculus and compiles under v0.4 of cjcc.
// To compile and run:	cjcc -o numbers.c numbers.j
//			gcc -o numbers numbers.c	 
//			numbers  
// Author: Peter Selinger, University of Pennsylvania			 
// Copyright (C) 1996 Peter Selinger
// This is free software under the terms of the GNU General Public License. 

def main<> -->

def /* exceptions */
	exc<e>		-->	write<"Exception: ",k1,_> | s<e>
  and	k1<> | s<e>	-->	write<e,k2,_>
  and	k2<>		-->	write<"\n",main,_>
  and	eofexc<e>	-->	write<"\nEnd Of File.\n",_,_>
in

def /* output */
	output<s,d,q,p,a,b,cont> --> ss<s> | sd<d> | sq<q> 
					| sp<p> | k0<> | st<a,b> | ct<cont>
  and	k0<>		--> write<"The sum is: ",k1,_>
  and   k1<> | ss<x>	--> write<x,k2,_>
  and	k2<>		--> write<"\nThe difference is: ",k3,_>   
  and   k3<> | sd<x>	--> write<x,k4,_>
  and	k4<>		--> write<"\nThe product is: ",k5,_>   
  and   k5<> | sp<x>	--> write<x,k6,_>
  and	k6<>		--> write<"\nThe quotient is: ",k7,_>   
  and   k7<> | sq<x>	--> write<x,k8,_>
  and   st<a,b>         --> equal<a,b,eq,_>
  and   eq<t>		--> if<t,then,else,exc>
  and   then<> | k8<>	--> write<"\nThe numbers are equal.\n",k9,_>
  and   else<> | k8<>	--> write<"\nThe numbers are not equal.\n",k9,_>
  and	k9<> | ct<cont> --> cont<>
in

def /* calculations */
	calc<a,b,cont>	--> plus<a,b,ksum,exc> 
			  | minus<a,b,kdiff,exc>
			  | div<a,b,kquot,exc>
			  | times<a,b,kprod,exc>
			  | store<a,b,cont>
  and	  ksum<sum> 
	| kdiff<diff> 
	| kquot<quot> 
	| kprod<prod> 
	| store<a,b,cont>--> output<sum,diff,quot,prod,a,b,cont>
in
 
def /* inputnumbers */	
	start<>		--> write<"Please type two numbers: ",k1,_>
  and	k1<>		--> readint<n1,eofexc>
  and	n1<a>		--> s1<a> | readint<n2,eofexc>
  and	s1<a> | n2<b>   --> calc<a,b,again> 
  and   again<>		--> start<>
in start<>

in main<>
