#include <stdio.h>
#include <stdlib.h>

struct incarnation;
struct queue;
struct queuelink;

typedef struct channel{
  struct incarnation *inc;
  int entry;
} channel;

#define CHANNEL 1
#define INT 2
#define STR 3
#define BOOLE 4
#define WILDCARD 5
typedef struct value {
  int type;       /* one of CHANNEL, INT, STR, BOOLE, WILDCARD */
  union {
    channel chan; /* type=CHANNEL */
    int i;        /* type=INT */
    char *s;      /* type=STR */
    int b;        /* type=BOOLE */
  } c;
} value;

void printvalue(FILE *file, value v);

value dummy;
value tmp_val;

value inint(int i) {
  value out;

  out.type=INT;
  out.c.i=i;
  return out;
}

value instr(char *s) {
  value out;

  out.type=STR;
  out.c.s=s;
  return out;
}

value inboole(int b) {
  value out;

  out.type=BOOLE;
  out.c.b=b;
  return out;
}

typedef struct incarnation {
  void (*code)(struct incarnation *, int);
  struct queue *q;
  int *arity;
  value *v;
} incarnation;

int run_time_err(char *s) {
  printf("\nRuntime Error:\n%s.\n",s);
  exit(1);
}

int run_time_err2(char *s,int i) {
  printf("\nRuntime Error:\n");
  printf(s, i);
  printf(".\n");
  exit(1);
}

typedef struct queuelink {
  value v;
  struct queuelink *next;
} queuelink;

typedef struct queue {
  queuelink *first;
  queuelink **last;
  int len;
} queue;

void init_queue(queue *q) {
  q->len=0;
  q->last=&q->first;
}

int push(value v, queue *q) {
  queuelink *ptr;
  ptr=(queuelink *)calloc(1,sizeof(queuelink));
  if (ptr==NULL)
    return 0;
  ptr->v=v;
  *(q->last)=ptr;
  q->last=&ptr->next;
  q->len++;
  return 1;
}

int pop(value *v, queue *q) {
  queuelink *ptr;

  if (q->len==0)
    return 0;
  ptr=q->first;
  *v=ptr->v;
  q->first=ptr->next;
  free(ptr);
  q->len--;
  if (q->len==0)
    q->last=&q->first;
  return 1;
}

int queue_length(queue *q) {
  return q->len;
}

