 /* join.lex */
 /* This is part of the source for the Core Join Calculus Compiler cjcc */
 /* Copyright (C) 1996 Peter Selinger */
 /* This is free software under the terms of the GNU General Public License. */

name		[a-zA-Z][a-zA-Z0-9_]*
strconst	\"[^"]*\"
intconst	-?[0-9]*

%%
def			{remember(yytext); return DEF;}

in			{remember(yytext); return IN;}

and			{remember(yytext); return AND;}

"-->"			{remember(yytext); return THEN;}

{intconst}		{remember(yytext); yylval.ic = atoi(yytext); 
			 return INTCONST;}

{strconst}		{remember(yytext); 
			 yylval.sc = strclone(removequotes(yytext)); 
			 return STRCONST;}

true                    {remember(yytext); yylval.bc = 1;
			 return BOOLECONST;}

false                   {remember(yytext); yylval.bc  = 0;
                         return BOOLECONST;}

"_"                     {remember(yytext); return WILDCARD;}

{name}			{remember(yytext); 
			 yylval.na = strclone(yytext); return NAME;}

"//"[^\n]*\n		{/* erase one-line comments */}

[ \t]+			{/* eat up white space */}

"\n"			{global_input_line++; 
			/* eat up space but count lines */}

.			{remember(yytext); return yytext[0];}


