/* makestrconst.c: This program converts an arbitrary character
   sequence to a C string. It acts as a filter. The characters 
   \, //, /*, ", ', and any embedded non-printable characters are
   escaped. The character % is *not* escaped: If a string containing
   such characters is to be printed literally by printf, use the form
   printf("%s", s). */

#include <stdio.h>

int main()
{
  int ch;
  
  putchar('\"');
  while ((ch=getchar())!=EOF) {
    if (ch == '\\')
      printf("\\\\");
    else if (ch == '\"')
      printf("\\\"");
    else if (ch == '\'')
      printf("\\\'");
    else if (ch == '\n')
      printf("\\n\"\n\"");
    else if (ch == '\t')
      printf("\\t");
    else if (ch < 32 || ch>126) 
      printf("\\%03o", ch);
    else
      putchar(ch);
  }
  putchar('\"');
  return 0;
}
