void printvalue(FILE *file, value v)
{
  switch (v.type) {
  case INT:
    fprintf(file, "%d", v.c.i);
    break;
  case STR:
    fprintf(file, "%s", v.c.s);
    break;
  case BOOLE:
    fprintf(file, "%s", v.c.b ? "true" : "false");
    break;
  case CHANNEL:
    fprintf(file, 
	    "[channel %d (arity %d) of incarnation %p of definition %p]", 
	    v.c.chan.entry, v.c.chan.inc->arity[v.c.chan.entry], 
	    v.c.chan.inc, v.c.chan.inc->code);
    break;
  case WILDCARD:
    fprintf(file, "*");
    break;
  }
}

#define SACCSIZE 255

int readint(FILE *file, value *out_val)
{
  int i,stat;
  static char sacc[SACCSIZE];  /* string accumulator */
  
  stat=fscanf(file, "%s", sacc);
  if (stat==EOF)
    return EOF;
  if (stat==0)
    return 1;
  *out_val=inint(atoi(sacc));
  return 0;
}

/* Definition of the global server */

void server(incarnation *inc, int entry) 
{
  switch (entry) {
  case 0:      /* entry 0 is the 'write' server: write<printee,cont,exc> */
    if (queue_length(inc->q+entry) >= 3) {
      value printee,cont,exc;

      pop(&printee,inc->q+entry);
      pop(&cont,inc->q+entry);
      pop(&exc,inc->q+entry);
      printvalue(stdout,printee);
      sendalong0(cont);
    }
    break;
  case 1:      /* entry 1 is the 'readint' server: readint<cont,exc> */
    if (queue_length(inc->q+entry) >= 2) {
      value cont,exc;
      value result;
      int stat;
      pop(&cont,inc->q+entry);
      pop(&exc,inc->q+entry);
      stat=readint(stdin, &result);
      if (stat==EOF)
	sendalong1(exc,instr("End of file"));
      else if (stat)
	sendalong1(exc,instr("Bad input"));
      else 
	sendalong1(cont,result);
    }
    break;
                  /* Arithmetic operations */
  case 2:          /* entry 2 is test for equality */
  case 3:          /* entry 3 is 'plus': plus<first,second,cont,exc> */
  case 4:          /* entry 4 is 'minus' */
  case 5:          /* entry 5 is 'times' */
  case 6:          /* entry 6 is 'div' */
  case 7:          /* entry 7 is 'less' */
    if (queue_length(inc->q+entry) >= 4) {
      value first, second, cont, exc;
      pop(&first,inc->q+entry);
      pop(&second,inc->q+entry);
      pop(&cont,inc->q+entry);
      pop(&exc,inc->q+entry);
      if (first.type != INT || second.type !=INT) {
	if (entry==2)
	  sendalong1(exc,instr("Cannot test non-integers for equality"));
	else if (entry==7)
	  sendalong1(exc,instr("Cannot test non-integers for inequality"));
	else
	  sendalong1(exc,instr("Arithmetic operation on non-integers"));
	return;
      }
      switch (entry) {
      case 2: sendalong1(cont,inboole(first.c.i == second.c.i)); break;
      case 3: sendalong1(cont,inint(first.c.i + second.c.i)); break;
      case 4: sendalong1(cont,inint(first.c.i - second.c.i)); break;
      case 5: sendalong1(cont,inint(first.c.i * second.c.i)); break;
      case 6: 
	if (second.c.i==0)
	  sendalong1(exc,instr("Division by zero"));
	else
	  sendalong1(cont,inint(first.c.i / second.c.i)); 
	break;
      case 7: sendalong1(cont,inboole(first.c.i < second.c.i)); break;
      }
    }
    break;
  case 8:  /* entry 8 is if-then-else:  if<cond,thenk,elsek,exc> */
    if (queue_length(inc->q+entry) >= 4) {
      value cond, thenk, elsek, exc;
      pop(&cond,inc->q+entry);
      pop(&thenk,inc->q+entry);
      pop(&elsek,inc->q+entry);
      pop(&exc,inc->q+entry);
      if (cond.type != BOOLE) 
	sendalong1(exc,instr("First argument of 'if' is not a boolean"));
      else if (cond.c.b)
	sendalong0(thenk);
      else
	sendalong0(elsek);
    }
    break;
  }
} 

