/* types.h */
/* This is part of the source for the Core Join Calculus Compiler cjcc */
/* Copyright (C) 1996 Peter Selinger */
/* This is free software under the terms of the GNU General Public License. */

struct sem;
struct list;
#define SEM struct sem 
#define LST struct list

typedef struct {   /* exptype: semantic type of exp (i.e. name or constant) */
  SEM *precode;         /* code generated by the expression */
  SEM *funcode;         /* such that {precode} x=({funcode}); assigns
			   the value of the expression to an x of type
			   value. precode and funcode have access to a 
			   variable tmp_val of type value as temporary store */
  LST *free;            /* list of free variables of exp */
  SEM *term;            /* textual representation of the expression */
} exptype;

typedef struct {     /* explisttype: semantic type of explist v...v */
  SEM *code;           /* code generated by a explist (n 'push' op's) */
  int n;               /* length of the explist */
  LST *free;           /* list of free variables of explist */  
  SEM *term;           /* textual representation of the explist */
} explisttype;

typedef struct { /* processtype: semantic type of process P, message x<v..v>*/
  SEM *local;          /* local code of the process */
  SEM *global;         /* code that goes in the header */
  LST *free;          /* list of free names of the process */
} processtype;

typedef struct { /* parameterlisttype: semantic type of parameterlist v...v */
  LST *received;      /* ordered list of (received) names: must be disjoint!*/
  int n;               /* length */
} parameterlisttype;

typedef struct 
defa_pair     {  /* defapair: auxiliary. Pair of defined variable + arity */
  char *d;
  int a;
} defa_pair;

typedef struct 
receivertype {    /* receivertype: semantic type for receiver J=x<v...v> */
  defa_pair thisdefa; /* the defined variable/arity pair  x,n */
  LST *received;     /* an ordered list of the received variables v...v, 
			 must be disjoint! */
} receivertype;

typedef struct {  /* joinpatterntype: sem. type of joinpattern J|...|J */
  LST *pattern;       /* this is a list [des,...,des] of the
			  values of the receivers J */
  LST *received;      /* list of received names: must be disjoint! */
  LST *defa;          /* list of defined_name/arity pairs (see defapair) */
} joinpatterntype;

typedef struct 
basicdeftype {     /* basicdeftype: semantic value of basicdef J-->P */
  SEM *proccode;    /* local code of P just passed on */
  LST *free;       /* those free names of P that are not received */
  LST *received;   /* received names */
  LST *pattern;    /* this is passed on from joinpatterntype: a list
		       of the (receivertype) values of the receivers J */
  SEM *global;      /* global code of P */
  LST *defa;        /* list of defined_name/arity pairs of D */
} basicdeftype;

typedef struct {  /* definitiontype: sem. type of definition D */
  LST *collector; /* list of values of basicdef's */
  LST *defa;       /* list of defined_name/arity pairs of D */
  LST *free;       /* free is a list of variables such that
		       fv(D) < free < fv(D)-dv(D) */
  SEM *global;      /* the global code associated with all the P's */
} definitiontype;
